---
generated_at: 2026-02-03 10:20:00
metrics:
  claims_total: 15
  claims_with_evidence: 14
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：5-Pool Detail（プール詳細）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：14 / 15、根拠なし：1
- 優先レビュー（高）
  1. **PoolTableの表示カラム詳細（minShare/weight）**：PoolTable.scalaの直接読解が不足

## 2) 参照した情報（Evidence一覧）

- E-01: `core/src/main/scala/org/apache/spark/ui/jobs/PoolPage.scala` （PoolPageクラス全体）
- E-02: `core/src/main/scala/org/apache/spark/ui/jobs/StagesTab.scala` （StagesTabクラス）
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv` （画面No.5の行）
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` （画面No.5の関連機能）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URLパスは /stages/pool/?poolname={poolName} | E-01 (28行目: WebUIPage("pool")) | ○ |
| C-02 | poolnameパラメータが必須 | E-01 (31-35行目: Option/getOrElse例外) | ○ |
| C-03 | poolnameはURLデコードされる | E-01 (32行目: UIUtils.decodeURLParameter) | ○ |
| C-04 | sc.getPoolForNameでプールを取得 | E-01 (38行目) | ○ |
| C-05 | プールが存在しない場合は例外 | E-01 (39行目: "Unknown pool") | ○ |
| C-06 | PoolDataが存在しない場合は空デフォルト | E-01 (42-43行目: new PoolData(poolName, Set())) | ○ |
| C-07 | ステージはuiPool.stageIdsから取得 | E-01 (44行目: uiPool.stageIds.toSeq.map) | ○ |
| C-08 | StageTableBaseでテーブル生成 | E-01 (45-47行目) | ○ |
| C-09 | PoolTableでプールサマリー表示 | E-01 (49行目: new PoolTable) | ○ |
| C-10 | アクティブステージがある場合のみテーブル表示 | E-01 (51行目: activeStages.nonEmpty) | ○ |
| C-11 | セクションは折りたたみ可能 | E-01 (53-63行目: collapse-aggregated class) | ○ |
| C-12 | ページタイトルは"Fair Scheduler Pool: {poolName}" | E-01 (66行目) | ○ |
| C-13 | killEnabledが渡される | E-01 (47行目: parent.killEnabled) | ○ |
| C-14 | テーブルのsubPathは"stages/pool" | E-01 (47行目) | ○ |
| C-15 | PoolTableにminShare/weightカラムがある | **根拠なし**（PoolTable.scalaの直接読解なし） | △ |

## 4) 不足情報（Unknown / Missing）
- PoolTable.scalaの表示カラム定義
  - 候補：`core/src/main/scala/org/apache/spark/ui/jobs/PoolTable.scala`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - PoolPage.scalaの処理フローは完全に確認済み（68行の小さなクラス）
- 1: 中リスク - PoolTableの表示カラム詳細は間接確認のみ

## 6) レビュアーチェックリスト（最小）
- [ ] PoolTableの表示カラムが正確か確認（PoolTable.scalaを参照）
- [ ] FAIRスケジューラ未使用時のアクセス制限が正しく記載されているか確認
- [ ] poolnameのURLエンコード/デコード処理が正しいか確認
